from Tkinter import *
from visual import *
from random import random
import time,sys,thread

from NumericUnitCell import *
from VisualSphere import *

from visual import *
from random import random

import time,sys,thread

scene.title = "Simulation"
scene.width = 800
scene.height = 720
scene.x = 20
scene.y = 20
scene.autoscale = 1
scene.up = (0,0,1)
scene.fov = pi/30.0
scene.forward = (0.0,1.0,-1.0)
scene.lights = [vector(.5,.5,.5), vector(-.5,-.5,-.5)]
scene.background = (0,0,0)
scene.uniform = 1
scene.range = 1.0
##        scene.stereo = 'passive'
scene.select()

##equatorLine = curve(x=cos(arange(0,2.1*pi,.1565)), y=sin(arange(0,2.1*pi,.1565)), color=(.5,.5,.5))

print '-----------------------------'



        
class Simulation:
    nSpinsX = 2
    nSpinsY = 3

    uc = NumericUnitCell(nSpinsX,nSpinsY)
    vSphere = VisualSphere(nSpinsX,nSpinsY)

    dt = .0003

    Ja = -1.0
    Jbx = -1.0
    Jby = 0.80
    
    uc.setCouplings(Ja, Jbx, Jby)

    
    temp = 0.0*abs(Ja)

    k = 3.1416*vector(0.0,0.25,0.0)
    baseSigma = .5
    uc.setState(k, baseSigma)

    
    def __init__(self,parent):
        numLoops = 63                       # number of loops, each one can be random, for instance.
        numFrames = 255                     # Number of frames
        frameDuty = 63                      # Number of cycles per animation frame
        simuLength = numFrames*frameDuty    # Total time for simu, because I used nested for loops.
        
        thread.start_new_thread(self.animateSpins,(numLoops,numFrames,frameDuty))  


    def animateSpins(self,numLoops,numFrames,frameDuty):
        self.uc.permuteState(self.dt)
        scene.forward = self.uc.getCommonAxis()

##        visAxis = []
##        for x in arange(-2.0,2.01,1.0):
##            visAxis.append(x*norm(self.uc.getCommonAxis()))
##        axisLine = curve(pos=visAxis, color=(.8,.8,.8))


        for i in range(numLoops):
            self.vSphere.addPoints(self.uc.getState())
            self.vSphere.addVectors(self.uc.getState())
            self.vSphere.addTracers(self.uc.getState())

            for j in range(numFrames):

                for k in range(frameDuty):
                    self.uc.permuteState(self.dt)
                    self.uc.perturbState(self.dt,self.temp,self.Ja)
                    self.vSphere.updatePoints(self.uc.getState())

                self.vSphere.updateTracers(self.uc.getState())
                
            self.vSphere.resetVisuals()
            self.vSphere = VisualSphere(self.nSpinsX,self.nSpinsY)
            
            self.uc.randomizeState()                         # Randomize between sessions...
            scene.forward = self.uc.getCommonAxis()




    def setKx(self, kx):
        if (self.k.y == 0.0 and float(kx) == 0.0):
            pass
        else:
            self.k.x = float(kx)/(self.nSpinsX)

        print self.k

##        self.spins = self.initialize_spins(self.spins, self.k)
        
        pass

    def setKy(self, ky):
##        if (self.k.x == 0.0 and float(ky_string) == 0.0):
##            pass
##        else:
##            self.k.y = float(ky_string)/(self.Ntoty*self.dy)
##
##        self.set_spin_mag_ratio(self.k)
##        gammaratio_widget.set(self.spin_mag_ratio)
##        self.spins = self.initialize_spins(self.spins, self.k)

        pass


    def setGamma(self, gamma):
##        if float(gammaratio_string) != 0.0:
##            self.spin_mag_ratio = float(gammaratio_string)
##            
##            self.spins = self.initialize_spins(self.spins, self.k)
            
        pass
    

    def setJbxa(self, Jbxa):
##        self.Jbx = self.Ja*float(J_ratio_string)
##        self.Jby = self.Ja
##
##        if self.tv_stripes.get() == 1:
##            for row in self.spins:
##                for s in row:
##                    if s.indices[0]%self.stripe_x_spacing == 0:
##                        s.couplings[0] = self.Jbx
##                    if s.indices[0]%self.stripe_x_spacing == (self.stripe_x_spacing - 1):
##                        s.couplings[1] = self.Jbx
##                    if s.indices[1]%self.stripe_y_spacing == 0:
##                        s.couplings[2] = self.Jby
##                    if s.indices[1]%self.stripe_y_spacing == (self.stripe_y_spacing - 1):
##                        s.couplings[3] = self.Jby
##        else:
##            for row in self.spins:
##                for s in row:
##                    if s.indices[0]%self.stripe_x_spacing == 0:
##                        s.couplings[0] = self.Ja
##                    if s.indices[0]%self.stripe_x_spacing == (self.stripe_x_spacing - 1):
##                        s.couplings[1] = self.Ja
##                    if s.indices[1]%self.stripe_y_spacing == 0:
##                        s.couplings[2] = self.Ja
##                    if s.indices[1]%self.stripe_y_spacing == (self.stripe_y_spacing - 1):
##                        s.couplings[3] = self.Ja

        pass





######-------------------------------------------------------######
###                             TKR                             ###
        
##  Instance creation ##
tkr = Tk()
simu = Simulation(tkr)

##  TKR appearance and widget creation ##

########
tkr.wm_geometry(newGeometry="360x513+900+320")   
tkr.wm_title("Controls")

########
top_frame = Frame(tkr,relief=SUNKEN, borderwidth=0)
top_frame.grid(row=0, column=0, padx=0, pady=0)


########
##toggle_frame = Frame(top_frame, relief=FLAT, borderwidth=0)
##toggle_frame.grid(row=0, column=0, padx=4, pady=4)

######
##modes_frame = Frame(toggle_frame, relief=FLAT, borderwidth=1)
##modes_frame.grid(row=0, column=0, padx=4, pady=4)
##
###
##modes_label = Label(modes_frame, text="Mode Options:").grid(row=0, column=0, sticky=W)
##
##sigma_rep_label = Label(modes_frame, text="Sigmas").grid(row=1, column=0, sticky=E)
##sigma_rep_widget = Checkbutton(modes_frame, text="", variable=simu.tv_sigma_rep, command=simu.t_sigma_rep).grid(row=1, column=1)
##
##box_rep_label = Label(modes_frame, text="Boxes").grid(row=2, column=0, sticky=E)
##box_rep_widget = Checkbutton(modes_frame, text="", variable=simu.tv_box_rep, command=simu.t_box_rep).grid(row=2, column=1)
##
##sphere_rep_label = Label(modes_frame, text="Sphere").grid(row=3, column=0, sticky=E)
##sphere_rep_widget = Checkbutton(modes_frame, text="", variable=simu.tv_sphere_rep, command=simu.t_sphere_rep).grid(row=3, column=1)
##
##circles_label = Label(modes_frame, text="Circles").grid(row=1, column=2, sticky=E)
##circles_widget = Checkbutton(modes_frame, text="", variable=simu.tv_circles, command=simu.t_circles).grid(row=1, column=3)
##
##flatten_label = Label(modes_frame, text="Flatten").grid(row=2, column=2, sticky=E)
##flatten_widget = Checkbutton(modes_frame, text="", variable=simu.tv_flatten, command=simu.t_flatten).grid(row=2, column=3)
##
##points_label = Label(modes_frame, text="Points").grid(row=3, column=2, sticky=E)
##points_widget = Checkbutton(modes_frame, text="", variable=simu.tv_points, command=simu.t_points).grid(row=3, column=3)
##
###


######
##visuals_frame = Frame(toggle_frame, relief=FLAT, borderwidth=1)
##visuals_frame.grid(row=0, column=0, padx=4, pady=4)
##
###
##visuals_label = Label(visuals_frame, text="Visual Options:").grid(row=0, column=0, sticky=W)
##
##sublattices_label = Label(visuals_frame, text="Sublattices").grid(row=1, column=0, sticky=E)
##sublattices_widget = Checkbutton(visuals_frame, text="", variable=simu.tv_sublattices, command=simu.t_sublattices).grid(row=1, column=1)
##
##torque_label = Label(visuals_frame, text="Torques").grid(row=2, column=0, sticky=E)
##torque_widget = Checkbutton(visuals_frame, text="", variable=simu.tv_torques, command=simu.t_torques).grid(row=2, column=1)
##
##color_label = Label(visuals_frame, text="Colors").grid(row=3, column=0, sticky=E)
##color_widget = Checkbutton(visuals_frame, text="", variable=simu.tv_colors, command=simu.t_colors)
##color_widget.grid(row=3, column=1)
##color_widget.toggle()
##
##fm_filter_label = Label(visuals_frame, text="FM Filter").grid(row=4, column=0, sticky=E)
##fm_filter_widget = Checkbutton(visuals_frame, text="", variable=simu.tv_fm_filter, command=simu.t_fm_filter).grid(row=4, column=1)
###
##
##
##
######
##simu_frame = Frame(toggle_frame, relief=FLAT, borderwidth=0)
##simu_frame.grid(row=1, column=0, columnspan=2, padx=4, pady=4)
##
###
##simu_label = Label(simu_frame, text="Simulation:").grid(row=0, column=0, sticky=W)
##
##stripes_label = Label(simu_frame, text="Stripes").grid(row=1, column=0, sticky=E)
##stripes_widget = Checkbutton(simu_frame, text="", variable=simu.tv_stripes, command=simu.t_stripes).grid(row=1, column=1)
##
##randomize_widget = Button(simu_frame, text="Randomize", command=simu.randomize).grid(row=1, column=2, padx=4, pady=2)
##
##reset_widget = Button(simu_frame, text="Reset", command=simu.reset).grid(row=1, column=3, padx=4, pady=2)
###
##
##
##
####
scales_frame = Frame(top_frame, relief=FLAT, borderwidth=1)
scales_frame.grid(row=1, column=0, columnspan=2, padx=10, pady=10)

#
scales_label = Label(scales_frame, text="Scales:").grid(row=0, column=0, sticky=W)

kx_widget = Scale(scales_frame, orient=VERTICAL, from_=2.0*3.1416, to=0.0, resolution=0.001, label="kxLx", command=lambda str: simu.setKx(str))
##kx_widget.set(simu.k.x)
kx_widget.grid(row=1, column=0)

ky_widget = Scale(scales_frame, orient=VERTICAL, from_=2.0*3.1416, to=0.0, resolution=0.001, label="kyLy", command=lambda str: simu.setKy(str))
##ky_widget.set(simu.k.y)
ky_widget.grid(row=1, column=1)

gammaratio_widget = Scale(scales_frame, orient=VERTICAL, from_=1.000, to=-1.000, resolution=0.001, label="GR", command=lambda str: simu.setGamma(str))
##gammaratio_widget.set(simu.spin_mag_ratio)
gammaratio_widget.grid(row=1, column=2)

J_ratio_widget = Scale(scales_frame, orient=VERTICAL, from_=1.0, to=-1.0, resolution=0.05, label="JR", command=lambda str: simu.setJbxa(str))
##J_ratio_widget.set(simu.Jbx/simu.Ja)
J_ratio_widget.grid(row=1, column=3)
#
##
##
######
##scales2_frame = Frame(top_frame, relief=FLAT, borderwidth=1)
##scales2_frame.grid(row=2, column=0, columnspan=2, padx=10, pady=10)
##
###
##mean_field_down_widget = Scale(scales2_frame, orient=VERTICAL, from_=1.00, to=-1.00, resolution=0.01, label="MF D", command=lambda str: simu.set_mean_field_down(str))
##mean_field_down_widget.set(simu.mean_field_down)
##mean_field_down_widget.grid(row=0, column=0)
##
##mean_field_up_widget = Scale(scales2_frame, orient=VERTICAL, from_=1.00, to=-1.00, resolution=0.01, label="MF U", command=lambda str: simu.set_mean_field_up(str))
##mean_field_up_widget.set(simu.mean_field_up)
##mean_field_up_widget.grid(row=0, column=1)
##
##temp_widget = Scale(scales2_frame, orient=VERTICAL, from_=0.2, to=0, resolution=0.01, label="kT", command=lambda str: simu.set_temp(str))
##temp_widget.set(simu.temp)
##temp_widget.grid(row=0, column=2)
##
##dt_widget = Scale(scales2_frame, orient=VERTICAL, from_=50, to=0, label="dt", command=lambda str: simu.set_dt(str))
##dt_widget.set(simu.dt*1000.0)
##dt_widget.grid(row=0, column=3)
###

##  Enter the main TKR loop, starting the interface and program ##
tkr.mainloop()

